/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authc.rest;

import com.floragunn.codova.config.net.CacheConfig;
import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Metadata;
import com.floragunn.codova.documents.Parser;
import com.floragunn.codova.documents.UnexpectedDocumentStructureException;
import com.floragunn.codova.documents.patch.PatchableDocument;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.ValidationResult;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.searchguard.authc.AuthenticationDomain;
import com.floragunn.searchguard.authc.base.IPAddressAcceptanceRules;
import com.floragunn.searchguard.authc.base.StandardAuthenticationDomain;
import com.floragunn.searchguard.authc.rest.HttpAuthenticationFrontend;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.configuration.Destroyable;
import com.floragunn.searchguard.support.IPAddressCollection;
import com.floragunn.searchsupport.cstate.metrics.MetricsLevel;
import java.util.Collection;
import java.util.regex.Pattern;

public class RestAuthcConfig
implements PatchableDocument<RestAuthcConfig>,
Destroyable {
    public static final Metadata<RestAuthcConfig> META = Metadata.create(RestAuthcConfig.class, (String)"sg_authc", (String)"Authentication configuration for the REST API", (n, c) -> (RestAuthcConfig)RestAuthcConfig.parse(n, (ConfigurationRepository.Context)c).get(), (Metadata.Attribute[])new Metadata.Attribute[]{Metadata.Attribute.list((String)"auth_domains", Object.class, (String)"The authentication domains to use."), Metadata.Attribute.optional((String)"debug", Boolean.class, (String)"Enables authc debug mode. If true, /_searchguard/auth/debug provides debug information."), Metadata.Attribute.optional((String)"network", Object.class, (String)"Network-specific configuration."), Metadata.Attribute.optional((String)"user_cache", Object.class, (String)"User cache configuration.")});
    private final DocNode source;
    private final ImmutableList<AuthenticationDomain<HttpAuthenticationFrontend>> authenticationDomains;
    private final Network network;
    private final boolean debugEnabled;
    private final CacheConfig userCacheConfig;
    private final MetricsLevel metricsLevel;

    public RestAuthcConfig(DocNode source, ImmutableList<AuthenticationDomain<HttpAuthenticationFrontend>> authenticationDomains, Network network, CacheConfig userCacheConfig, boolean debugEnabled, MetricsLevel metricsLevel) {
        this.source = source;
        this.authenticationDomains = authenticationDomains;
        this.network = network;
        this.debugEnabled = debugEnabled;
        this.userCacheConfig = userCacheConfig;
        this.metricsLevel = metricsLevel;
    }

    public Object toBasicObject() {
        return this.source;
    }

    public static ValidationResult<RestAuthcConfig> parse(DocNode docNode, ConfigurationRepository.Context context) {
        ValidatingDocNode vNode;
        ValidationErrors validationErrors = new ValidationErrors();
        try {
            vNode = new ValidatingDocNode(docNode.splitDottedAttributeNamesToTree(), validationErrors);
        }
        catch (UnexpectedDocumentStructureException e) {
            return new ValidationResult(e.getValidationErrors());
        }
        MetricsLevel metricsLevel = (MetricsLevel)vNode.get("metrics").withDefault((Enum)MetricsLevel.BASIC).asEnum(MetricsLevel.class);
        ImmutableList authDomain = vNode.get("auth_domains").asList(n -> StandardAuthenticationDomain.parse(n, HttpAuthenticationFrontend.class, context, metricsLevel));
        Network network = (Network)vNode.get("network").by(Network::parse);
        boolean debugEnabled = vNode.get("debug").withDefault(false).asBoolean();
        CacheConfig userCacheConfig = (CacheConfig)vNode.get("user_cache").withDefault((Object)CacheConfig.DEFAULT).by(CacheConfig::new);
        vNode.checkForUnusedAttributes();
        return new ValidationResult((Object)new RestAuthcConfig(docNode, (ImmutableList<AuthenticationDomain<HttpAuthenticationFrontend>>)ImmutableList.of((Collection)authDomain), network, userCacheConfig, debugEnabled, metricsLevel), validationErrors);
    }

    public static RestAuthcConfig empty(DocNode docNode) {
        return new RestAuthcConfig(docNode, (ImmutableList<AuthenticationDomain<HttpAuthenticationFrontend>>)ImmutableList.empty(), null, CacheConfig.DEFAULT, false, MetricsLevel.BASIC);
    }

    public Network getNetwork() {
        return this.network;
    }

    public ImmutableList<AuthenticationDomain<HttpAuthenticationFrontend>> getAuthenticators() {
        return this.authenticationDomains;
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public CacheConfig getUserCacheConfig() {
        return this.userCacheConfig;
    }

    public String toString() {
        return "RestAuthcConfig [authenticators=" + this.authenticationDomains + ", network=" + this.network + ", debugEnabled=" + this.debugEnabled + ", userCacheConfig=" + this.userCacheConfig + "]";
    }

    public RestAuthcConfig parseI(DocNode docNode, Parser.Context context) throws ConfigValidationException {
        return (RestAuthcConfig)RestAuthcConfig.parse(docNode, (ConfigurationRepository.Context)context).get();
    }

    public Metadata<RestAuthcConfig> meta() {
        return META;
    }

    @Override
    public void destroy() {
        for (AuthenticationDomain authenticationDomain : this.authenticationDomains) {
            if (!(authenticationDomain instanceof Destroyable)) continue;
            ((Destroyable)((Object)authenticationDomain)).destroy();
        }
    }

    protected MetricsLevel getMetricsLevel() {
        return this.metricsLevel;
    }

    public static class Network {
        private final IPAddressCollection trustedProxies;
        @Deprecated
        private final Pattern trustedProxiesPattern;
        private final String remoteIpHttpHeader;
        private final IPAddressAcceptanceRules ipAddressAcceptanceRules;

        public Network(IPAddressCollection trustedProxies, IPAddressAcceptanceRules ipAddressAcceptanceRules, Pattern trustedProxiesPattern, String remoteIpHttpHeader) {
            this.trustedProxies = trustedProxies;
            this.trustedProxiesPattern = trustedProxiesPattern;
            this.remoteIpHttpHeader = remoteIpHttpHeader;
            this.ipAddressAcceptanceRules = ipAddressAcceptanceRules;
        }

        static Network parse(DocNode docNode) throws ConfigValidationException {
            ValidationErrors validationErrors = new ValidationErrors();
            ValidatingDocNode vNode = new ValidatingDocNode(docNode, validationErrors);
            IPAddressCollection trustedProxies = (IPAddressCollection)vNode.get("trusted_proxies").by(IPAddressCollection::parse);
            Pattern trustedProxiesPattern = vNode.get("trusted_proxies_regex").asPattern();
            String remoteIpHttpHeader = vNode.get("http.remote_ip_header").withDefault("X-Forwarded-For").asString();
            IPAddressAcceptanceRules acceptanceRules = new IPAddressAcceptanceRules((IPAddressAcceptanceRules.Criteria)vNode.get("accept").by(IPAddressAcceptanceRules.Criteria::parse), (IPAddressAcceptanceRules.Criteria)vNode.get("deny").by(IPAddressAcceptanceRules.Criteria::parse));
            vNode.checkForUnusedAttributes();
            validationErrors.throwExceptionForPresentErrors();
            return new Network(trustedProxies, acceptanceRules, trustedProxiesPattern, remoteIpHttpHeader);
        }

        public static Network parseLegacy(DocNode docNode) throws ConfigValidationException {
            ValidationErrors validationErrors = new ValidationErrors();
            ValidatingDocNode vNode = new ValidatingDocNode(docNode, validationErrors);
            Pattern trustedProxiesPattern = vNode.get("internalProxies").asPattern();
            String remoteIpHttpHeader = vNode.get("remoteIpHeader").withDefault("X-Forwarded-For").asString();
            validationErrors.throwExceptionForPresentErrors();
            return new Network(null, IPAddressAcceptanceRules.ANY, trustedProxiesPattern, remoteIpHttpHeader);
        }

        public IPAddressCollection getTrustedProxies() {
            return this.trustedProxies;
        }

        @Deprecated
        public Pattern getTrustedProxiesPattern() {
            return this.trustedProxiesPattern;
        }

        public boolean hasTrustedProxies() {
            return this.trustedProxies != null || this.trustedProxiesPattern != null;
        }

        public String getRemoteIpHttpHeader() {
            return this.remoteIpHttpHeader;
        }

        public IPAddressAcceptanceRules getIpAddressAcceptanceRules() {
            return this.ipAddressAcceptanceRules;
        }
    }
}

